#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Lights onMod01.fsh   by  McZonk   
//https://www.shadertoy.com/view/ld2Gz3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

struct Ray {
	vec3 origin;
	vec3 direction;
};
	
struct Material {
	vec3 ambient;
	vec3 diffuse;
	vec3 specular;
	float shine;
	float reflectivity;
};
	
struct Sphere {
	vec3 origin;
	float radius;
};

struct Plane {
	vec3 direction;
	float dis;
};
	
struct PointLight {
	vec3 origin;
	vec3 color;
};

struct Output {
	vec3 origin;
	vec3 normal;
	float dis;
	Material material;
};

const float PI = 3.1415926536;

#define planeCount 1
Plane plane[planeCount];

#define sphereCount 5
Sphere sphere[sphereCount];

#define lightCount 6
PointLight light[lightCount];

vec3 eye;

const int materialCount = 2;
Material material[2];

Sphere makeSphere(float offset) {
	float t = iTime + PI * 2.0 * offset;
	float x = cos(t) * 3.0;
	float z = sin(t * 2.0) * 1.5;
	return Sphere(vec3(x, 0.8, z), 0.8);
}

void makeScene() {
	{
		material[0] = Material(
			vec3(0.0, 0.0, 0.0),
			vec3(0.3, 0.3, 0.3),
			vec3(1.0, 1.0, 1.0),
			80.0,
			0.4
		);
		
		material[1] = Material(
			vec3(0.0, 0.0, 0.0),
			vec3(0.5, 0.5, 0.5),
			vec3(1.0, 1.0, 1.0),
			40.0,
			0.6
		);
	}
	
	{
		plane[0].direction = vec3(0.0, 1.0, 0.0);
		plane[0].dis = 0.0;

		sphere[0] = makeSphere(0.0 / 5.0);
		sphere[1] = makeSphere(1.0 / 5.0);
		sphere[2] = makeSphere(2.0 / 5.0);
		sphere[3] = makeSphere(3.0 / 5.0);
		sphere[4] = makeSphere(4.0 / 5.0);
	}

	{
		float r = 4.0;
		float y = 4.0;
		
		float t0 = -iTime + PI * 0.0;
		light[0].origin = vec3(cos(t0) * r, y, sin(t0) * r);
		light[0].color = vec3(0.5, 0.0, 0.0);

		float t1 = -iTime + PI * 0.333333;
		light[1].origin = vec3(cos(t1) * r, y, sin(t1) * r);
		light[1].color = vec3(0.4, 0.4, 0.0);

		float t2 = -iTime + PI * 0.666666;
		light[2].origin = vec3(cos(t2) * r, y, sin(t2) * r);
		light[2].color = vec3(0.0, 0.5, 0.0);

		float t3 = -iTime + PI * 1.0;
		light[3].origin = vec3(cos(t3) * r, y, sin(t3) * r);
		light[3].color = vec3(0.0, 0.4, 0.4);

		float t4 = -iTime + PI * 1.333333;
		light[4].origin = vec3(cos(t4) * r, y, sin(t4) * r);
		light[4].color = vec3(0.0, 0.0, 0.5);

		float t5 = -iTime + PI * 1.666666;
		light[5].origin = vec3(cos(t5) * r, y, sin(t5) * r);
		light[5].color = vec3(0.4, 0.0, 0.4);
	}
}

void intersectSphere(const Sphere sphere, const Ray ray, Material material, inout Output o) {
	vec3 d = ray.origin - sphere.origin;
	
	float a = dot(ray.direction, ray.direction);
	float b = dot(ray.direction, d);
	float c = dot(d, d) - sphere.radius * sphere.radius;
	
	float g = b*b - a*c;
	
	if(g > 0.0) {
		float dis = (-sqrt(g) - b) / a;
		if(dis > 0.0 && dis < o.dis) {
			o.dis = dis;
			o.origin = ray.origin + ray.direction * dis;
			o.normal = (o.origin - sphere.origin) / sphere.radius;
			o.material = material;
		}
	}
}

void intersectPlane(const Plane plane, const Ray ray, Material material, inout Output o) {
	float dis = plane.dis - dot(plane.direction, ray.origin) / dot(plane.direction, ray.direction);
	
	bool hit = false;
	if(dis > 0.0 && dis < o.dis) {
		o.dis = dis;
		o.origin = ray.origin + ray.direction * dis;
		o.normal = faceforward(plane.direction, plane.direction, ray.direction);
		o.material = material;
		
		// checkerboard hack
		vec2 cb = floor(o.origin.xz);
		float cb2 = mod(cb.x + cb.y, 2.0);
		o.material.ambient *= cb2 + 1.2;
		o.material.diffuse *= cb2 + 1.2;
		o.material.specular *= cb2 + 1.2;
	}
}


vec3 illuminatePointLight(PointLight light, Output o) {
	vec3 v = normalize(light.origin - o.origin);
	
	float d = clamp(dot(o.normal, v), 0.0, 1.0);
	float s = 0.0;
	if(d > 0.0) {
		vec3 eyeV = normalize(eye - o.origin);
		vec3 h = normalize(v + eyeV);
		s = pow(clamp(dot(o.normal, h), 0.0, 1.0), o.material.shine);
	}
	
	vec3 diffuse  = o.material.diffuse  * light.color * d;
	vec3 specular = o.material.specular * light.color * s;
	return diffuse + specular;
}

vec3 illumiate(Output o) {
	vec3 color = o.material.ambient;
	
	for(int i = 0; i < lightCount; ++i) {
		color += illuminatePointLight(light[i], o);
	}
	
	float dis = length(eye - o.origin);
	
	dis -= 4.0;
	dis *= 0.07;
	dis = clamp(dis, 0.0, 1.0);
	
	return color * (1.0 - dis);
}

Output raytraceIteration(Ray ray) {
	Output o;
	o.origin = vec3(0.0, 0.0, 0.0);
	o.normal = vec3(0.0, 0.0, 1.0); 
	o.dis = 1.0e4;
	o.material = Material(
		vec3(0.0, 0.0, 0.0),
		vec3(0.0, 0.0, 0.0),
		vec3(0.0, 0.0, 0.0),
		0.0,
		0.0
	);

	for(int i = 0; i < planeCount; ++i) {
		intersectPlane(plane[i], ray, material[0], o);
	}
	for(int i = 0; i < sphereCount; ++i) {
		intersectSphere(sphere[i], ray, material[1], o);
	}

	return o;
}

vec3 raytrace(Ray ray) {
	vec3 color = vec3(0.0, 0.0, 0.0);
	
	float reflectivity = 1.0;
	
	for(int i = 0; i < 4; ++i) {
		Output o = raytraceIteration(ray);
		
		if(o.dis >= 1.0e3) {
			break;
		}
		
		color += illumiate(o) * reflectivity;
		
		float l = length(ray.origin - o.origin) + 0.0001;
		color -= 0.02 / l;

		reflectivity *= o.material.reflectivity;
		if(reflectivity < 0.05) {
			break;
		}
		
		ray = Ray(o.origin + o.normal * 0.0001, reflect(normalize(o.origin - ray.origin), o.normal));
	}
	
	return color;
}

Ray getPrimaryRay(vec3 origin, vec3 lookat, vec2 fragCoord) {
	vec2 uv = (fragCoord.xy * 2.0 - iResolution.xy) / iResolution.xx;

	vec3 forward = normalize(lookat - origin);
	vec3 up = vec3(0.0, 1.0, 0.0);
	
	vec3 right = cross(up, forward);
	up = cross(forward, right);
	
	Ray ray;
	
	ray.origin = origin;
	ray.direction = normalize(right * uv.x + up * uv.y + forward);
	
	eye = ray.origin;
	
	return ray;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	makeScene();
	
	float xo = (iMouse.x * 2.0 / iResolution.x - 1.0) * PI;
	float yo = (0.5 - (iMouse.y / iResolution.y)) * 4.0 + 2.01;
	
	eye = vec3(cos(iTime * 0.1 + xo) * 5.0, yo, sin(iTime * 0.1 + xo) * 5.0);
	
	vec3 lookat = vec3(0.0, 0.0, 0.0);
	
	Ray ray = getPrimaryRay(eye, lookat, fragCoord);
	
	vec3 color = raytrace(ray);
	
	fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

